<?php
Class Anatomia extends CI_Model{
   
   function Index(){
      $this->db->select('rut,dv, nombres, ap_paterno, ap_materno');
      $this->db->from('personas');        
      $query = $this->db->get(); 
      if($query->num_rows() >= 1){
	return $query->result();
      }else{
	return false;
      }
   }

   function Examenes_Solicitados(){
      $this->db->select('examenes.id, examenes.fecha, examenes.rut, personas.dv, personas.nombres, personas.ap_paterno, personas.ap_materno, examenes.organo');
      $this->db->from('examenes');        
      $this->db->join('personas', 'examenes.rut = personas.rut');        
      $query = $this->db->get(); 
      if($query->num_rows() >= 1){
	return $query->result();
      }else{
	return false;
      }
   }

   function CrearPaciente($valores){
      $this->db->insert('personas', $valores);   
      if($this->db->affected_rows() == 1){
          return true;
      } else {
          return $this->db->_error_message();
      }        
   }

    function getPersona($pk)
    {
      $this->db->select('rut,dv, nombres, ap_paterno, ap_materno');
      $this->db->from('personas');        
      $this->db->where('rut',$pk);        
      $this->db->limit(1);        
      $query = $this->db->get(); 
      if($query->num_rows() >= 1){
	 return $query->result();
      }else{
	 return false;
      }
   } 
   
   function CrearExamen($valores){
      $this->db->set('fecha', 'NOW()', FALSE);
      $this->db->insert('examenes', $valores);   
      if($this->db->affected_rows() == 1){
          return true;
      } else {
          return $this->db->_error_message();
      }        
   }
   
   function getExamen($id){
      $this->db->select('examenes.id, examenes.fecha, examenes.informe, personas.rut, personas.dv, personas.nombres, personas.ap_paterno, personas.ap_materno');
      $this->db->from('examenes');        
      $this->db->join('personas', 'examenes.rut = personas.rut');        
      $this->db->where('examenes.id',$id);        
      $this->db->limit(1);        
      $query = $this->db->get(); 
      if($query->num_rows() >= 1){
	return $query->result();
      } else {
	return false;
      }
   } 
    
   function ActualizarExamen($id, $valores){
      $valores["informe"] = htmlentities($valores["informe"]);
      $valores["informe"] = str_replace("\n", "", $valores["informe"]);
      $this->db->where('id',$id);
      $this->db->update('examenes', $valores);            
      if($this->db->affected_rows() == 1){
        return true;
      } else {
        return $this->db->_error_message();
      }
   }      
    
   function BorrarExamen($examen){
      $this->db->where('examen', $examen);
      $this->db->delete('examenes'); 
      if($this->db->affected_rows() == 1){
        return true;
      }else{
        return $this->db->_error_message();
      }
   }     
}