<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Inicio extends CI_Controller {
   function __construct(){
      parent::__construct();
      $this->load->model('clinica','',TRUE);
      //$this->load->library('session');
      $this->load->library('session');
   }    
   public function index(){
      if ($this->session->userdata('username')){
	 $sessiondata = array(
	    "username" => $this->session->userdata('username')
	 );
	 $this->load->view('inicio', $sessiondata);
      } else {
	 redirect("login"); 
      }
   }        

   public function Insertar_Paciente(){
      $rut = $this->input->post('rut');
      $dv = $this->input->post('dv');
      $nombres = $this->input->post('nombres');
      $paterno = $this->input->post('paterno');
      $materno = $this->input->post('materno');

      $valores=array(   
	  "rut"=>$rut,
	  "dv"=>$dv,
	  "nombres"=>$nombres,
	  "ap_paterno"=>$paterno,
	  "ap_materno"=>$materno
      );

      $respuesta = $this->login_model->CrearPaciente($valores);
      if($respuesta)
      {
	  echo "alert('Registro Insertado');";
      }
      else {
	  echo "alert('Error al insertar');";
      }

   }      
        
   public function Insertar_Examen(){
      $rut = $this->input->post('rut');
      $genero = $this->input->post('opt_genero');
      $edad = $this->input->post('edad');
      $prevision = $this->input->post('prevision');
      $procedencia = $this->input->post('procedencia');
      $servicio = $this->input->post('servicio');
      $solicitante = $this->input->post('solicitante');
      $fecha_intervencion = $this->input->post('fecha_intervencion');
      $organo = $this->input->post('organo');
      $fecha_intervencion = substr($fecha_intervencion, 6,4).'-'.substr($fecha_intervencion, 3,2).'-'.substr($fecha_intervencion,0,2);
      $valores=array(   
	  "rut"=>$rut,
	  "genero"=>$genero,
	  "edad"=>$edad,
	  "prevision"=>$prevision,
	  "procedencia"=>$procedencia,
	  "solicitante"=>$solicitante,
	  "fecha_intervencion"=>$fecha_intervencion,		
	  "organo"=>$organo,
	  "servicio"=>$servicio
      );

      $respuesta = $this->login_model->CrearExamen($valores);
      if($respuesta)
      {
	  echo "alert('Registro Insertado');";
      }
      else {
	  echo "alert('Error al insertar');";
      }
		
   }      
        
   public function Tabla_Personas(){
      $respuesta = $this->anatomia->index();
      $parametros=array("listado_personas"=>$respuesta);
      $this->load->view('tabla_personas',$parametros);
   }

   public function Tabla_Informe(){
      $respuesta = $this->anatomia->examenes_solicitados();
      $parametros=array("listado_examenes"=>$respuesta);
      $this->load->view('tabla_informe',$parametros);
   }

   public function Tabla_Estadistica(){
      $respuesta = $this->anatomia->examenes_solicitados();
      $parametros=array("listado_examenes"=>$respuesta);
      $this->load->view('tabla_estadistica',$parametros);
   }

   public function Editar_Informe(){
      $id=$this->input->post('id');            
      //echo "EJEMPLO: ".$pk;
      $respuesta = $this->anatomia->getExamen($id);
      $parametros=array("persona"=>  json_encode($respuesta));
      $this->load->view('editar_informe',$parametros);
   }        

   public function Editar_Estadistica(){
      $pk=$this->input->post('pk');            
      //echo "EJEMPLO: ".$pk;
      $respuesta = $this->anatomia->getPersona($pk);
      $parametros=array("persona"=>  json_encode($respuesta));
      $this->load->view('editar_estadistica',$parametros);
   }        

   public function Nuevo_examen(){                        
      $this->load->view('nuevo_examen');
   } 
   
   public function Editar_Persona(){
      $pk=$this->input->post('pk');            
      $respuesta = $this->anatomia->getPersona($pk);
      $parametros=array("persona"=>  json_encode($respuesta));
      $this->load->view('editar_persona',$parametros);
   }        

   public function Buscar_Persona(){
      $pk=$this->input->post('rut');            
      $respuesta = $this->anatomia->getPersona($pk);
      $parametros=array("persona"=>  json_encode($respuesta));
      $parametros=json_encode($respuesta);
      echo $parametros;
   }        

   public function Actualizar_Persona(){
      $rut = $this->input->post('rut');
      $dv = $this->input->post('dv');
      $nombres = $this->input->post('nombres');
      $paterno = $this->input->post('paterno');
      $materno = $this->input->post('materno');

      $valores=array(
	  "nombres"=>$nombres,
	  "ap_paterno"=>$paterno,
	  "ap_materno"=>$materno
      );

      $respuesta = $this->anatomia->ActualizarPersona($valores,$rut);
      if($respuesta){
	  echo "alert('Registro Actualizado');";
      } else {
	  echo "alert('Error al Actualizar');";
      }
		
   }
   
   public function Actualizar_Informe(){
      $id = $this->input->post('id');
      $informe = $this->input->post('informe');

      $valores=array(
	  "informe"=>$informe
      );

      $respuesta = $this->anatomia->ActualizarExamen($id, $valores);
      if($respuesta){
	  echo "alert('Registro Actualizado');";
      } else {
	  echo "alert('Error al Actualizar');";
      }
		
   }
   
   public function Actualizar_Estadistica(){
      $key2 = $this->input->post("key2");
      $rut = $this->input->post('rut');
      $dv = $this->input->post('dv');
      $nombres = $this->input->post('nombres');
      $paterno = $this->input->post('paterno');
      $materno = $this->input->post('materno');
            
      $valores=array(
                "nombres"=>$nombres,
                "ap_paterno"=>$paterno,
                "ap_materno"=>$materno
      );
            
      $respuesta = $this->anatomia->ActualizarPersona($valores,$rut);
      if($respuesta){
	 echo "alert('Registro Actualizado');";
      } else {
	 echo "alert('Error al Actualizar');";
      }
		
   }
   
   public function Eliminar_Persona(){
      $rut = $this->input->post('rut');                                    
      $respuesta = $this->anatomia->BorrarPersona($rut);
      if($respuesta){
	 echo "alert('Registro Eliminado');";
      } else {
	 echo "alert('Error al Eliminar');";
      }	
   }
   
   public function cerrar_sesion(){
      $this->session->sess_destroy();
      redirect("login");
   }
}
